// $Id: CModulatedSlider.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CModulatedSlider.hpp"
using Exponent::GUI::Controls::CModulatedSlider;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CModulatedSlider, CRangeSlider);

//	===========================================================================
CModulatedSlider::CModulatedSlider(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener) 
				: CRangeSlider(root, uniqueId, area, listener)
				, m_modulatedValue(0.0)
{
	EXPONENT_CLASS_CONSTRUCTION(CModulatedSlider);

	// Store the value
	m_modulatedValue = this->getValue();

	// Set the rectangle
	m_modulatedSlider.setRect(0, 0, m_area.getWidth(), 2);
}

//	===========================================================================
CModulatedSlider::~CModulatedSlider()
{
	EXPONENT_CLASS_DESTRUCTION(CModulatedSlider);
}

//	===========================================================================
void CModulatedSlider::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Draw the slider
	CRangeSlider::drawControl(graphics);

	// Draw the modulation position
	graphics.getMutablePen()->setColour(CAlphaColour::CALPHACOLOUR_ORANGE);
	graphics.drawRectangle(m_modulatedSlider);
}

//	===========================================================================
void CModulatedSlider::setModulationValue(const double value)
{
	if (m_modulatedValue >= 0.0 && m_modulatedValue <= 1.0 && m_modulatedValue != value)
	{
		// Store the value
		m_modulatedValue = value;
		if (m_isVertical)
		{
			m_modulatedSlider.setTop((long)((1.0 - m_modulatedValue) * m_area.getHeight()));
		}
		else
		{
			m_modulatedSlider.setLeft((long)(m_modulatedValue * m_area.getWidth()));
		}
		this->update();
	}
}